<?php
/**
 * Month name declension
 *
 * Developed originaly by Wacław Jacek for Polish localization of WordPress https://core.trac.wordpress.org/ticket/11226#comment:10
 * Modified for Croatian localization by Robert Borenić
 *
 * @since 3.8.3
 */

/* filters */
add_filter( 'date_i18n', 'date_declension' );

/* functions */
function date_declension( $date )
{
	$month_names = array( '/Siječanj/', '/Veljača/', '/Ožujak/', '/Travanj/', '/Svibanj/', '/Lipanj/', '/Srpanj/', '/Kolovoz/', '/Rujan/', '/Listopad/', '/Studeni/', '/Prosinac/' );
	$month_names_genitive = array( 'siječnja', 'veljače', 'ožujka', 'travnja', 'svibnja', 'lipnja', 'srpnja', 'kolovoza', 'rujna', 'listopada', 'studenoga', 'prosinca' );
	
	/* "1. Siječanj..." -> "1. siječnja..." */
	$pattern = '/^\d{1,2}.\ \w+/';
	if ( preg_match( $pattern, $date ) ) return preg_replace( $month_names, $month_names_genitive, $date );
	return $date;
}
?>