<?php
// displays the translations fields

if (isset($term_id)) {
	// edit term form?>
	<th scope="row"><?php _e('Translations', 'ait-languages');?></th>
	<td><?php
}
else {
	// add term form?>
	<label><?php _e('Translations', 'ait-languages');?></label><?php
}?>
<table class="widefat term-translations">
	<thead><tr><?php
		echo '<th class="tr-language-column">'.__('Language', 'ait-languages').'</th>';
		echo '<th>'.__('Translation', 'ait-languages').'</th>';
		if (isset($term_id))
			echo '<th class="tr-edit-column">'.__('Edit', 'ait-languages').'</th>';?>
	</tr></thead>
	<tbody>
		<?php foreach ($this->model->get_languages_list() as $language) {
			if ($language->term_id == $lang->term_id)
				continue;

			// look for any existing translation in this language
			$translation = 0;
			if (isset($term_id) && $translation_id = $this->model->get_translation('term', $term_id, $language))
				$translation = get_term($translation_id, $taxonomy);
			if (isset($_GET['from_tag']) && $translation_id = $this->model->get_term($_GET['from_tag'], $language))
				$translation = get_term($translation_id, $taxonomy);?>

			<tr><td class="tr-language-column"><?php echo esc_html($language->name);?></td><?php

			// no translation exists in this language
			if (!$translation) {
				// look for untranslated terms in this language
				$translations = $this->get_terms_not_translated($taxonomy, $language, $lang);
				if (!empty($translations)) { ?>
					<td>
						<?php printf('<select name="term_tr_lang[%1$s]" id="tr_lang_%1$s">', esc_attr($language->slug)); ?>
							<option value="0"></option><?php
							foreach ($translations as $translation)
								printf('<option value="%s">%s</option>', esc_attr($translation->term_id), esc_html($translation->name));?>
						</select>
					</td><?php
				}
				else
					echo '<td>'.__('No untranslated term', 'ait-languages').'</td>';

				// do not display the add new link in add term form ($term_id not set !!!)
				if (isset($term_id)) {
					$args = array(
						'taxonomy'  => $taxonomy,
						'post_type' => $post_type,
						'from_tag'  => $term_id,
						'new_lang'  => $language->slug
					);
					printf(
						'<td class="tr-edit-column"><a href="%1$s">%2$s</a></td>',
						esc_url(add_query_arg($args, admin_url('edit-tags.php'))),
						__('Add new','ait-languages')
					);
				}
			}

			// a translation exists
			else {
				printf(
					'<td><input type="hidden" name="term_tr_lang[%s]" value="%d" />%s</td>',
					esc_attr($language->slug),
					esc_attr($translation->term_id),
					esc_html($translation->name)
				);
				if (isset($term_id))
					printf(
						'<td class="tr-edit-column"><a href="%1$s">%2$s</a></td>',
						esc_url(get_edit_term_link($translation->term_id, $taxonomy, $post_type)),
						__('Edit','ait-languages')
					);
			} ?>
			</tr><?php
		} // foreach ?>
	</tbody>
</table><?php

if (isset($term_id)) {
	// edit term form?>
	</td><?php
}
