
<div class="form-wrap">
	<form id="options-lang" method="post" action="<?php echo admin_url('admin.php?page=ait-languages&amp;tab=settings&amp;noheader=true') ?>" class="validate">
	<?php wp_nonce_field('options-lang', '_wpnonce_options-lang');?>
	<input type="hidden" name="pll_action" value="options" />

	<!-- <input name="browser" type="hidden" value="0"> -->
	<!-- <input name="force_lang" type="hidden" value="0"> -->
	<input name="domains[en]" type="hidden" value="">
	<input name="rewrite" type="hidden" value="1">
	<input name="hide_default" type="hidden" value="1">
	<input name="redirect_lang" type="hidden" value="1">
	<!-- <input name="media_support" type="hidden" value="1"> -->

	<?php
		foreach(get_post_types(array('ait-translatable-cpt' => true)) as $cpt){
			printf("<input name='post_types[%s]' type='hidden' value='1'> ", $cpt);
		}

		foreach(get_taxonomies(array('ait-translatable-tax' => true)) as $cpt){
			printf("<input name='taxonomies[%s]' type='hidden' value='1'> ", $cpt);
		}
	?>

	<table class="form-table">

		<tr>
			<th><label for='default_lang'><?php _e('Default language', 'ait-languages');?></label></th>
			<td><?php
				$dropdown = new PLL_Walker_Dropdown;
				echo $dropdown->walk($listlanguages, array('name' => 'default_lang', 'selected' => $this->options['default_lang']));?>
			</td>
		</tr><?php

		// posts or terms without language set
		if ($this->model->get_objects_with_no_lang() && $this->options['default_lang']) {?>
			<tr>
				<th></th>
				<td>
					<label style="color: red"><?php
						printf(
							'<input name="fill_languages" type="checkbox" value="1" /> %s',
							__('There are posts, pages, categories or tags without language set. Do you want to set them all to default language ?', 'ait-languages')
						);?>
					</label>
				</td>
			</tr><?php
		}?>

		<?php

		if (!empty($post_types)) {?>
			<tr>
				<th scope="row"><?php _e('Custom post types', 'ait-languages') ?></th>
				<td>
					<ul class="pll_inline_block"><?php
						foreach ($post_types as $post_type) {
							$pt = get_post_type_object($post_type);
							printf(
								'<li><label><input name="post_types[%s]" type="checkbox" value="1" %s /> %s</label></li>',
								esc_attr($post_type),
								in_array($post_type, $this->options['post_types']) ? 'checked="checked"' :'',
								esc_html($pt->labels->name)
							);
						}?>
					</ul>
					<p><?php _e('Activate languages and translations for custom post types.', 'ait-languages');?></p>
				</td>
			</tr><?php
		}

		if (!empty($taxonomies)) { ?>
			<tr>
				<th scope="row"><?php _e('Custom taxonomies', 'ait-languages') ?></th>
				<td>
					<ul class="pll_inline_block"><?php
						foreach ($taxonomies as $taxonomy) {
							$tax = get_taxonomy($taxonomy);
							printf(
								'<li><label><input name="taxonomies[%s]" type="checkbox" value="1" %s /> %s</label></li>',
								esc_attr($taxonomy),
								in_array($taxonomy, $this->options['taxonomies']) ? 'checked="checked"' :'',
								esc_html($tax->labels->name)
							);
						}?>
					</ul>
					<p><?php _e('Activate languages and translations for custom taxonomies.', 'ait-languages');?></p>
				</td>
			</tr><?php
		}

		?>


	</table>

	<?php submit_button(); ?>

	</form>
</div><!-- form-wrap -->
