<?php
if (isset($_GET['error'])) {?>
<div id="message" class="error fade"><p><?php echo $errors[$_GET['error']]; ?></p></div><?php
}?>

<div id="col-container">

	<div id="col-right">
		<div class="col-wrap"><?php
			// displays the language list in a table
			$list_table->display();?>
		</div><!-- col-wrap -->
	</div><!-- col-right -->


	<div id="col-left">
		<div class="col-wrap">

			<div class="form-wrap">
				<h3><?php echo $action=='edit' ? __('Edit language', 'ait-languages') :	__('Add new language', 'ait-languages'); ?></h3><?php

				// displays the add (or edit) language form
				// adds noheader=true in the action url to allow using wp_redirect when processing the form ?>
				<form id="add-lang" method="post" action="<?php echo admin_url('admin.php?page=ait-languages&amp;noheader=true') ?>" class="validate">
				<?php wp_nonce_field('add-lang', '_wpnonce_add-lang');

				if ($action=='edit') {?>
					<input type="hidden" name="pll_action" value="update" />
					<input type="hidden" name="lang_id" value="<?php echo esc_attr($edit_lang->term_id);?>">

					<?php
				}
				else { ?>
					<input type="hidden" name="pll_action" value="add" /><?php
				}?>

				<?php if ($action != 'edit'): ?>
				<div class="form-field">
					<label for="lang_list"><?php _e('Choose a language', 'ait-languages');?></label>
					<select name="lang_list" id="lang_list">
						<option value=""></option><?php

						include(PLL_ADMIN_INC.'/languages.php');

						$usedLangs = $this->model->get_languages_list(array('fields' => 'locale'));
						foreach ($languages as $lg) {
							if(in_array($lg[1], $usedLangs)) continue;
							printf(
								'<option value="%1$s-%2$s-%3$s">%4$s - (%5$s, %2$s)</option>'."\n",
								esc_attr($lg[0]),
								esc_attr($lg[1]),
								isset($lg[3]) ? '1' : '0',
								esc_html($lg[2]),
								esc_attr($lg[0])
							);
						} ?>
					</select>
					<p><?php _e('You can choose a language in the list or directly edit it below.', 'ait-languages');?></p>
				</div>
				<?php endif; ?>


				<?php if ($action=='edit'): ?>
				<div class="form-field form-required">
					<label for="lang_name"><?php _e('Full name', 'ait-languages');?></label>
					<input name="name" id="lang_name" type="text" value="<?php if ($action=='edit') echo esc_attr($edit_lang->name);?>" size="40" aria-required="true" />
					<p><?php _e('The name is how it is displayed on your site (for example: English).', 'ait-languages');?></p>
				</div>
				<?php else: ?>
					<input name="name" id="lang_name" type="hidden" value="<?php if ($action=='edit') echo esc_attr($edit_lang->name);?>">
				<?php endif; ?>


				<input name="locale" id="lang_locale" type="hidden" value="<?php if ($action=='edit') echo esc_attr($edit_lang->locale);?>">
				<input name="slug" id="lang_slug" type="hidden" value="<?php if ($action=='edit') echo esc_attr($edit_lang->slug);?>">
				<input name="rtl" type="hidden" value="0">

				<?php if ($action=='edit'): ?>
				<div class="form-field">
					<label for="lang_order"><?php _e('Order', 'ait-languages');?></label>
					<input name="term_group" id="lang_order" type="text" value="<?php if ($action=='edit') echo esc_attr($edit_lang->term_group);?>" />
					<p><?php _e('Position of the language in the language switcher', 'ait-languages');?></p>
				</div>
				<?php else: ?>
					<input name="term_group" id="lang_order" type="hidden" value="<?php if ($action=='edit') echo esc_attr($edit_lang->term_group);?>">
				<?php endif; ?>


				<?php submit_button( $action == 'edit' ? __('Update') : __('Add new language', 'ait-languages'), 'button'); ?>

				</form>
			</div><!-- form-wrap -->
		</div><!-- col-wrap -->
	</div><!-- col-left -->
</div><!-- col-container -->
